using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace takm62025_26
{
    internal class Point
    {
        public long x, y;
        public double dist;

        public Point(long x, long y)
        {
            this.x = x;
            this.y = y;
            this.dist = Math.Sqrt(x * x + y * y);
        }
        public void SetXY(long x, long y)
        {
            this.x = x;
            this.y = y;
            this.dist = Math.Sqrt(y * y + x * x);
        }
    }
    internal class Program
    {
        static void Main(string[] args)
        {
            int n = int.Parse(Console.ReadLine());
            Point[] movements = new Point[n];
            List<int> points = new List<int>();
            for(int i = 0; i< n; i++)
            {
                string[] input = Console.ReadLine().Split(' ');
                movements[i] = new Point(long.Parse(input[0]), long.Parse(input[1]));
            }
            long tx = 0;
            long ty = 0;
            for(int i = 0; i < n; i++)
            {
                tx+= movements[i].x;
                ty+= movements[i].y;
            }
            Point total = new Point(tx, ty);
            Point final = new Point(tx, ty);
            for(int i = 0; i < n; i++)
            {
                Point temp = new Point(final.x - movements[i].x, final.y - movements[i].y);
                if (temp.dist > final.dist)
                {
                    final.SetXY(temp.x, temp.y);
                }
                else points.Add(i);
            }
            Console.WriteLine(points.Count);
            for(int i = 0; i < points.Count; i++)
            {
                Console.Write((points[i]+1) + " ");
            }
        }
    }
}